-- Autor: Rick Black Labele TWD Modding (GPT Supportet) 04.10.2025
-- IncreaseTreeLimit.lua
-- Liest den Wert aus der eigenen modDesc.xml und setzt g_treePlantManager.maxNumTrees beim Missionsstart.

local function readMaxFromModDesc()
    -- g_currentModDirectory ist in FS-Skripten verfügbar und zeigt auf das Verzeichnis des aktuellen Mods
    local modDescPath = g_currentModDirectory .. "modDesc.xml"
    local xml = loadXMLFile("IncreaseTreeLimitModDesc", modDescPath)
    if xml == 0 then
        print("IncreaseTreeLimit: konnte modDesc.xml nicht laden, verwende 30000 als Fallback")
        return 30000
    end

    local v = getXMLInt(xml, "modDesc.extraSettings#maxNumTrees")
    delete(xml)
    if v == nil or v == 0 then
        return 30000
    end
    return tonumber(v)
end

local desiredMax = readMaxFromModDesc()

local function onMissionStart()
    if g_treePlantManager ~= nil then
        -- Sicherheitscheck: ensure at least 1
        desiredMax = math.max(1, tonumber(desiredMax) or 30000)

        -- Setze den Max-Wert direkt (Server-seitig).
        g_treePlantManager.maxNumTrees = desiredMax

        Logging.info("IncreaseTreeLimit: maxNumTrees wurde auf %d gesetzt", g_treePlantManager.maxNumTrees)
    else
        Logging.info("IncreaseTreeLimit: g_treePlantManager nicht gefunden")
    end
end

-- Listener: Mission start ist der richtige Zeitpunkt (TreePlantManager wurde dann bereits geladen).
g_messageCenter:subscribeOneshot(MessageType.CURRENT_MISSION_START, onMissionStart)
